** apriamo il file log
** l'opzione "replace" dopo la virgola permette di sotituire un file presente nella cartella con lo stesso nome
** se usiamo l'opzione "append" continuiamo un log file che abbiamo gi aperto
log using "C:\Users\Greta\ownCloud\POLITO\2020-2021\EFI\Materiale EFI - Econometria2020\2020_GRE\DO_LOG_2020\AKLZ_Falavigna_econometria2020.log",replace
** NB: RICORDARSI DI CHIUDERE IL LOG FILE!!!!!!! Comando: "log close"

** carichiamo i dati su Stata. 
** NB: ricordarsi di impostare la prima riga come nomi di colonna.
** NB2: controllre che i valori numerici siano scritti in NERO, se sono ROSSI Stata li legge come stringhe. Controllare che . e , siano letti correttamente
import excel "C:\Users\Greta\ownCloud\POLITO\2020-2021\EFI\Materiale EFI - Econometria2020\2020_GRE\DO_LOG_2020\sw_caschool.xls", sheet("Foglio1") firstrow

** salvo i dati in formato Stata (dta)
save "C:\Users\Greta\ownCloud\POLITO\2020-2021\EFI\Materiale EFI - Econometria2020\2020_GRE\DO_LOG_2020\sw_Caschool.dta", replace

** Variabili presenti nel dataset
* DIST_CODE: DISTRICT CODE;
* READ_SCR: AVG READING SCORE;
* MATH_SCR: AVG MATH SCORE;
* COUNTY : COUNTY;
* DISTRICT: DISTRICT;
* GR_SPAN: GRADE SPAN OF DISTRICT;
* ENRL_TOT : TOTAL ENROLLMENT;
* TEACHERS: NUMBER OF TEACHERS;
* COMPUTER: NUMBER OF COMPUTERS;
* TESTSCR: AVG TEST SCORE (= (READ_SCR+MATH_SCR)/2 );
* COMP_STU: COMPUTERS PER STUDENT ( = COMPUTER/ENRL_TOT);
* EXPN_STU: EXPENTITURES PER STUDENT ($S);
* STR: STUDENT TEACHER RATIO (ENRL_TOT/TEACHERS);
* EL_PCT: PERCENT OF ENGLISH LEARNERS;
* MEAL_PCT: PERCENT QUALIFYING FOR REDUCED-PRICE LUNCH;
* CALW_PCT: PERCENT QUALIFYING FOR CALWORKS;
* AVGINC: DISTRICT AVERAGE INCOME (IN $1000'S);
*******************************************
*******************************************
**** CAPITOLI 1, 2 e 3 ********************

* descrizione dei dati
des 
sum

* vediamo le variabili STR e TESTSCR usante il comando edit oppure il comando browse. Sono due comandi del tutto equivalenti. 
edit str testscr
* browse str testscr

* Plot dei dati direttamente nella finestra dei risultati 
scatter  testscr str

* count
count if str<20

sum str if str<20
sum str if str>=20
* Risultati slide 21
sum  testscr if str<20
sum testscr if str>=20

* facciamo lo scatter delle osservazioni in base al valore di str
scatter testscr str if str<20
scatter testscr str if str>=20
twoway (scatter testscr str if str<20) (scatter testscr str if str>=20)


* vediamo il dettaglio del comando summarize
sum testscr str, detail
** Skewness: indice di asimmetria. Se = 0 --> Simmetria
** Kurtosis: appiattimento/allungamento rispetto al valore medio (Pearson). Se > 0 pi appuntita (leptocurtosi). Se < 0 pi appiattita (platicurtosi)

* verifichiamo graficamente la kurtosis e la skewness
* istogramma
hist testscr, freq
hist str, freq
kdensity testscr, normal
kdensity str, normal

* tabelle descrittive. * Dai men: STATISTICS --> SUMMARIES,... --> TABLES --> TABSTAT
tabstat str testscr, statistics( mean sd p10 p25 p50 p75 p90 ) columns(variables)
tabstat str testscr, statistics( mean sd p10 p25 p50 p75 p90 ) columns(stats)


* Calcoliamo le stesse statistiche per il campione ridotto
tabstat str testscr, statistics( mean sd p10 p25 p50 p75 p90 ) columns(stats), if(str<20)
tabstat str testscr, statistics( mean sd p10 p25 p50 p75 p90 ) columns(stats), if(str>=20)

* calcoliamo la correlazione tra str e testscr
corr  testscr str
corr testscr str, means

* generiamo una variabile dummy (dicotomica) dum_small in cui troveremo 1 dove la variabile str presenta valori inferiori a 20; 0 altrove
* 0  il gruppo grande (>=20 studenti); 1  il gruppo piccolo
gen dum_small=str<20
edit str dum_small 
tab dum_small
* creiamo due grafici con le distribuzioni a confronto e vediamo se notiamo gi una relazione
scatter testscr str, by(dum_small)

* guardiamo il comando che ci consente di fare il test
help ttest

* facciamo un test t che confronti le medie ottenute nel test dai due gruppi definiti con la variabile dum_small. I due gruppi (con molti o pochi studenti) hanno medie uguali?
* Stata genera la differenza con il segno -. Questo perch il test  costruito facendo la differenza delle medie gruppi come: media del gruppo 0-media del gruppo 1, cio nel nostro esempio media del gruppo formato da classi grandi e 1 classi formate da pochi studenti
ttest testscr, by(dum_small)
* rigettiamo h0, test bidirezionale (risultato centrale). Accettiamo l'ipotesi alternativa che le medie siano statisticamente differenti.
* guardiamo i risultati dei test proposti. Rigettiamo H0 anche quando l'ipotesi alternativa  che la media nei testscore delle classi grandi  inferiore alla media nei testscore delle classi piccole. Risultato a sinistra (test monodirezionale)
* (Ha: diff<0)

* testiamo l'ipotesi che il punteggio del test sia uguale a 0
ttest testscr==0
* rigettiamo H0 (test  bidirezionale)
* rigettiamo H0 (test monodirezionale). 

***********************************************************
***********************************************************
********** CAPITOLO 4 *************************************

*Regressione e previsione degli errori della regressione
* Robust variance estimates. _robust is a programmer's command that computes a robust variance estimator based on a varlist of equation-level scores and a covariance matrix.  It produces estimators for ordinary
* data (each observation independent), clustered data (data not independent within groups, but independent across groups), and complex survey data from one stage of stratified cluster
* sampling.

regress testscr str

** utilizziamo "robust" per gli errori eteroschedastici
regress testscr str, robust

* mostriamo il risultato su un grafico NB: aaplot va scaricato con il comando: 
* ssc install aaplot
aaplot testscr str
aaplot  testscr str, lopts(lc(blue)) aformat(%04.3f) bformat(%06.5f) rmseformat(%4.3f)
* visualizziamo lo scatter di str e testscr delle prime 7 osservazioni per guardare come vengono costruiti gli errori
aaplot testscr str if  ObservationNumber<8

* salviamo i dati della regressione in un doc
outreg2 using "C:\Users\Greta\ownCloud\POLITO\2020-2021\EFI\Materiale EFI - Econometria2020\2020_GRE\DO_LOG_2020\prova.doc", replace

* Costruiamo gli errori per capire come funziona la regressione.
* Calcoliamo gli errori con il comando predict, fare il predict subito dopo aver stimato la reg
* "resid" come opzione ci consente di stimare gli errori della regressione per ogni osservazione
predict errori, resid
* Facciamo il predict dei valori di testscr attravwerso il comando predict
predict testscr_prev
* Generiamo una variabile differenza tra i valori empirici e quelli previsti dal modello
gen errori_man=testscr-testscr_prev
* Guardiamo le variabili testscr; testscr_prev; errori; errori_man
edit testscr testscr_prev errori errori_man
* Facciamo il plot del valori fittati. Costruisco in sostanza il grafico che ottengo con il comando aaplot
twoway (scatter testscr str) (scatter  testscr_prev str) 

* disegnamo le nostre distribuzioni di errori, valori previsti e valori reali
twoway (scatter errori  ObservationNumber) (scatter  testscr_prev  ObservationNumber)
twoway (scatter errori  ObservationNumber) (scatter  testscr_prev  ObservationNumber) if ObservationNumber<10
twoway (scatter errori  ObservationNumber) (scatter  testscr_prev  ObservationNumber) (scatter testscr  ObservationNumber) 
twoway (scatter errori  ObservationNumber) (scatter  testscr_prev  ObservationNumber) (scatter testscr  ObservationNumber) if ObservationNumber<10

* Vediamo se i risultati cambiano considerando le classi piccole
regress testscr str if str<20, robust
* gen dum_small=str<20
regress testscr str if dum_small==1, robust 

* Vediamo se cambiano considerando le classi grandi
regress testscr str if str>=20, robust
regress testscr str if dum_small==0, robust 
* per cancellare
* drop dum_small

* facciamo un plot semplice. Diversit da scatter
plot testscr str

*disegnamo i dati
scatter testscr str

*Inseriamo pi di un grafico
twoway (scatter testscr str) (lfit testscr str, estopts(robust))

* Disegnamo anche gli intervalli di confidenza
twoway (scatter testscr str) (lfitci testscr str, estopts(robust))

* Facciamo un plot considerando i due campioni suddivisi in base al valore di STR
aaplot  testscr str if str<20
aaplot  testscr str if str>=20
scatter testscr str, by(dum_small)

******************************************************
******************************************************
******************************************************
* Andiamo a vedere il distretto Antelope Elementary, slide 14. Ripetiamo il comando regress
* come esempio nelle slide
drop errori
regress testscr str, robust
* Cancelliamo gli errori se abbiamo fatto delle prove precedenti
predict errori, resid
predict testscr_Ant if district=="Antelope Elementary"
edit testscr testscr_Ant errori district

* outliers
* Generiamo una variabile str_fake che  uguale alla variabile str tranne nella posizione 6 in cui vale 2000
generate str_fake=str
replace str_fake=10000 in 6
edit str str_fake
* Proviamo a fare la regressione con la variabile corretta e con quella con l'outlier
regress testscr str, robust
regress testscr str_fake,robust

* Slide 18 sulla bont della regressione. R2: Divisione tra SSModel e totale SS
* se gi calcolati
* drop errori testscr_prev
reg testscr str
reg testscr str, robust

* verifichiamo che r-quadro sia il quadrato della correlazione tra x e y
corr testscr str
gen r_quadro=-0.2264*(-0.2264)
edit r_quadro

* Calcoliamo i valori previsti della variabile testscr e calcoliamo gli errori
predict testscr_prev
predict errori, resid

* Verifichiamo che la somma dei valori previsti pi gli errori genera esattamente il valore osservato nel campione
gen testscr_y=testscr_prev+errori
edit testscr_prev errori testscr_y testscr
kdensity errori, normal
kdensity testscr_prev, normal
* verifichiamo se sono distribuiti secondo una normale pnorm=Standardized normal probability plot
pnorm errori

* twoway (kdensity errori) (kdensity testscr_prev)
sum errori, detail
sum testscr_prev, detail

* creiamo i valori della variabile originale yi costruendo la retta di regressione
reg testscr str, robust
gen testscr_prova= 698.933-2.279808*str+errori
edit testscr_prova testscr

**************************++++++
********************************
****** CAPITOLO 5 **************

* omoschedaticit e omoschedaticit
reg testscr str
reg testscr str, robust

* come cambia il commento e il calcolo se usiamo variabili dummy? 0 sono le classi grandi; 1 le piccole
gen dum_small=str<20

sum testscr if dum_small==0
sum testscr if dum_small==1
reg testscr dum_small, robust

**************************++++++
********************************
****** CAPITOLO 6 **************

** inseriamo nella regressione la variabile  el_pct: % studenti NON madrelingua
** Variabile omessa se:
* 1) determinante di y
* 2) determinante di x
sum el_pct, detail
corr(testscr el_pct), means
corr(str el_pct), means
* tabelle descrittive. * Dai men: STATISTICS --> SUMMARIES,... --> TABLES --> TABSTAT
tabstat el_pct, statistics( mean sd p25 p50 p75 ) columns(variables)
tabstat el_pct, statistics( mean sd p25 p50 p75 ) columns(variables)

**** Come cambia il valore del Beta di STR (_b[STR])  dopo l'inclusione di el_pct

reg testscr str el_pct, robust
reg testscr str el_pct

* collinearit perfetta: La collinearit perfetta si ha quando uno dei regressori  funzione lineare esatta degli altri
* slide 32
reg testscr str str, robust

reg testscr dum_small, robust
gen dum_B=1-dum_small
reg testscr dum_small dum_B, robust
reg testscr dum_small dum_B, noc robust


* dum_small:0 se classe grande; 1 se classe piccola
sum dum_small
tab dum_small
* la trappola delle variabili dummy
* partendo da dum_small creo 2 variabili dummy: dum_small_1 quando le classi sono grandi; dum_small_2 quando le classi sonon piccole
* in realt dum_small2  uguale a dum_small poich dum_small ha solo due categorie. Tuttavia, questo  mlto utile quando dobbiamo creare variabili dummy
* partendo da una variabile categorica. Si penso a una variabile con le macro-aree geografiche. 
tab dum_small, gen(dum_small_)
reg testscr str  dum_small_1 dum_small_2, robust
reg testscr str  dum_small_1 dum_small_2, noc robust


corr( enrl_tot comp_stu expn_stu str avginc el_pct)
corr(expn_stu str)
scatter  str expn_stu
reg testscr str expn_stu, robust
reg testscr str, robust

**************************++++++
********************************
****** CAPITOLO 7 **************


***** Test di 2 restrizioni su 2 coefficienti

***** Verifico se le risorse investite nella scuola influenzano l'apprendimento

regress testscr str expn_stu el_pct, robust
test str expn_stu

**** Il test rifiuta l'ipotesi nulla che entrambi i coefficienti siano nulli
**** Quindi le risorse investite nella scuola "contano"

***** Confronto il test effettutato su stime robuste e non robuste all'etroschedasticit 

regress testscr str expn_stu el_pct 
test str expn_stu
regress testscr str expn_stu el_pct, robust
test str expn_stu

*** La statistica 'F della stima non robusta  maggiore dell'F della stima robusta 
*** Quindi il test con la stime non robusta mi fa rifiutare l'ipotesi nulla anche quando non posso  

**** Test di una restrizione su pi coefficienti


***** Primo metodo: trasformazione dell'equazione 
**** Test di una restrizione su pi coefficienti


***** H0: str=expn_stu? 


***** Primo metodo: trasformazione dell'equazione 

regress testscr str expn_stu el_pct, robust
generate somma= str+expn_stu
regress testscr str somma el_pct,robust

***** il coefficiente di str non   significativo 
***** b1-b2=0, cio non posso rifiutare l'ipotesi che il coefficiente di STR sia uguale al coefficiente di EXPN_STU 
  
**** Secondo metodo: verifico direttamente col test di stata

regress testscr str expn_stu el_pct, robust
test str=expn_stru 

**** Stesso risultato: Non posso rifiutare che il coefficiente di STR sia uguale al coefficiente di EXPN_STU 



**************************++++++
********************************
****** CAPITOLO 8 **************

** Funzioni di regressioni non lineari 

* Polinomiali in X 

generate avginc2=avginc*avginc
generate avging3=avginc^3

regress testscr avginc, robust
regress testscr avginc avginc2, robust
regress testscr avginc avginc2 avginc3, robust

test avginc2 avginc3

* in base al test di ipotesi congiunte H0: avginc2=0 e avginc3=0, rifiuto la relazione lineare tra testscr e avginc

* Funzioni logaritmiche di Y e/o X 

generate lavginc=log(avginc)
plot testscr lavginc
generate ltestscr=log(testscr)
scatter ltestscr lavginc 

* Funzione lin-log
regress testscr lavginc, robust 
* un incremento dell'1% in avginc  associato a un aumento di 0.36 punti nel test


* Funzione log-lineare 
regress ltestscr avginc, robust 
* un incremento di 1000 Euro - cio 1 (un) migliaio di Euro - nel reddito  associato a un aumento dello 0.28% nel punteggio

* Funzione log-log 
regress ltestscr lavginc
* un aumento dell' 1% nel reddito  associato a un aumento dello 0.0554% nel punteggio del test


** Interazioni tra variabili indipendenti 


* interazioni tra due variabili binarie 

generate hiel= el_pct>=10
generate histr= str>=20
generate histr_hiel=hiel*histr

regress testscr histr hiel, robust
regress testscr histr hiel histr_hiel, robust

* interazioni tra una variabile continua e una binaria

generate str_hiel=str*hiel

regress testscr str hiel str_hiel, robust
* testo se le due rette di regressione coincidono: se l'intercetta e la pendenza sono uguali 
test hiel str_hiel
* si rifiuta l'ipotesi congiunta che intercetta (hiel) e pendenza (str_hiel) siano uguali


* interazioni tra due variabili continue 

generate str_elpct=str*el_pct

regress testscr str el_pct str_elpct, robust 
* test se la dimensione delle classi  statisticamente significativa
test str str_elpct
* si rifiuta l'ipotesi nulla che la dimensione delle classi non influisca sull'apprendimento (voto del test) 


* cancelliamo i dati in memoria
clear

* chiudiamo il file log
log close


* cancelliamo i dati in memoria
clear

* chiudiamo il file log
log close

